********************************************************
*** Figure 1: Behaviour around financial crisis ***
********************************************************
clear all
use "$dataPath\Data"
do "$codePath\Transforming_variables"
xtset country_id period
cd "$outputFigures"

* Help variable to find period around crisis
gen crisis_cycle = .
replace crisis_cycle = 0 if start_crisis == 1
forvalues i=1(1)16 {
	replace crisis_cycle = `i' if start_crisisl`i' == 1
	}
forvalues i=1(1)16 {
	replace crisis_cycle = -`i' if start_crisisf`i' == 1
	}	 

* Event window is +/- 4 years around the crisis									
local quarterstart=-16															//start of quarterly window
local quarterend=16																//end of quarterly window

tsset country_id period, quarterly	
local start=`quarterstart'
local end=`quarterend'

* Defining the financial crisis and other crisis
gen global_crisis = 0
gen other_crises = 0
replace global_crisis = start_crisis if year >= 2005
replace other_crises = start_crisis if year < 2005

* Generating the dummyvariables (distance from the crisis)
forvalues i=-16(1)16 {
		if `i'<0	{
			local j=-`i'
			qui generate gcrisis`j'=F`j'.global_crisis							 
			qui replace gcrisis`j'=0 if gcrisis`j'==.
			
			qui generate ocrisis`j'=F`j'.other_crises							 
			qui replace ocrisis`j'=0 if ocrisis`j'==.
		}
		else {
			qui generate gcrisisL`i'=L`i'.global_crisis
			qui replace gcrisisL`i'=0 if gcrisisL`i'==.
			
			qui generate ocrisisL`i'=L`i'.other_crises
			qui replace ocrisisL`i'=0 if ocrisisL`i'==.
		}
	}
			 

* Just for help
gen zero = 0

foreach var in dlogrGDP gdp_gap global_credit_gap global_hp_gap {
	replace `var' = 100*`var'
	}



set more off
foreach var in global_hp_gap {
			   
local graphtitle : variable label `var' 										// Graphtitle

xtreg `var' ocrisis* gcrisis*, fe vce(robust) 								    // The regression

* Panel a) in Figure 3

coefplot, vertical drop(_cons ocrisis*) recast(line) col("221 34 45") lpattern(dash) xline(0, lcolor(black) lpattern(dash)) /// legend(order(2  "95 % CI") ring(0)  pos(11) region(fcolor(none) lcolor(none))) ///
		  xlabel(, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		  graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
		  relocate(gcrisis16 = -16 gcrisis15 = -15  gcrisis14 = -14 gcrisis13=-13 ///
		  gcrisis12 = -12 gcrisis11 = -11 gcrisis10 = -10 gcrisis9=-9 ///
		  gcrisis8 = -8 gcrisis7 = -7 gcrisis6 = -6 gcrisis5=-5 ///
		  gcrisis4 = -4 gcrisis3 = -3 gcrisis2 = -2 gcrisis1=-1 ///
		  gcrisisL0 = 0 gcrisisL1 = 1 gcrisisL2 = 2 gcrisisL3=3 ///
		  gcrisisL4 = 4 gcrisisL5 = 5 gcrisisL6 = 6 gcrisisL7=7 ///
		  gcrisisL8 = 8 gcrisisL9 = 9 gcrisisL10 = 10 gcrisisL11=11 ///
		  gcrisisL12 = 12 gcrisisL13 = 13 gcrisisL14 = 14 gcrisisL15=15 gcrisisL16=16) ///
		  citop ciopts(recast(rcap) color("44 115 153")) title("") xtitle(Quarters around the crisis) ytitle(Percentage points) yline(0, lcolor(black) lpattern(dash)) ///
 		  xlabel(-16(4)16) addplot((line zero crisis_cycle, sort col(black) lpattern(dash))) scale(1.4) ///
		  saving(`var'_g, replace) 
		  graph export `var'_g.pdf, replace
		  
* Panel b) in Figure 3

		  
coefplot, vertical drop(_cons gcrisis*) recast(line) col("221 34 45") lpattern(dash) xline(0, lcolor(black) lpattern(dash)) /// legend(order(2  "95 % CI") ring(0)  pos(11) region(fcolor(none) lcolor(none))) ///
		  xlabel(, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		  graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
		  relocate(ocrisis16 = -16 ocrisis15 = -15  ocrisis14 = -14 ocrisis13=-13 ///
		  ocrisis12 = -12 ocrisis11 = -11 ocrisis10 = -10 ocrisis9=-9 ///
		  ocrisis8 = -8 ocrisis7 = -7 ocrisis6 = -6 ocrisis5=-5 ///
		  ocrisis4 = -4 ocrisis3 = -3 ocrisis2 = -2 ocrisis1=-1 ///
		  ocrisisL0 = 0 ocrisisL1 = 1 ocrisisL2 = 2 ocrisisL3=3 ///
		  ocrisisL4 = 4 ocrisisL5 = 5 ocrisisL6 = 6 ocrisisL7=7 ///
		  ocrisisL8 = 8 ocrisisL9 = 9 ocrisisL10 = 10 ocrisisL11=11 ///
		  ocrisisL12 = 12 ocrisisL13 = 13 ocrisisL14 = 14 ocrisisL15=15 ocrisisL16=16) ///
		  citop ciopts(recast(rcap) color("44 115 153")) title("") xtitle(Quarters around the crisis) ytitle(Percentage points) yline(0, lcolor(black) lpattern(dash)) ///
 		  xlabel(-16(4)16) addplot((line zero crisis_cycle, sort col(black) lpattern(dash))) scale(1.4) ///
		  saving(`var'_o, replace) 
		  graph export `var'_o.pdf, replace
		  }



				
